#ifndef VPGISETUP_H__

#define VPGISETUP_H__



enum

{

	// --- Groups

	GI_GROUP_MAIN					= 100,

	GI_GROUP_GENERAL				= 200,

	GI_GROUP_SKY					= 300,

	GI_GROUP_QMC					= 400,

	GI_SETUP_QMC_HEMISPHERE				= 410,

	GI_SETUP_QMC_AREA				= 420,

	GI_SETUP_QMC_SKY				= 430,

	GI_SETUP_QMC_AO					= 440,

	GI_GROUP_IRRADIANCE				= 500,

	GI_GROUP_CACHES					= 600,

	GI_GROUP_CACHES_IRRADIANCE			= 610,

	GI_GROUP_CACHES_RADIANCE			= 620,

	GI_GROUP_CACHES_LIGHT_MAPPING			= 630,

	GI_GROUP_CACHES_LOCATION			= 640,

	GI_GROUP_IC2					= 700,

	GI_GROUP_RADIANCE				= 710,

	GI_GROUP_LIGHT_MAPPING				= 720,

	GI_GROUP_OPTIONS				= 730,



	// --- Static

	GI_SETUP_DATA_STATIC_DEPTH 			= 910,



	// --- Main

	GI_SETUP_DATA_UI_MODE				= 1000,



	// --- Animation (Legacy)

	GI_SETUP_DATA_ANIMATION_METHOD_EX		= 1100,

	GI_SETUP_DATA_ANIMATION_DETECTION_COMBO_EX,

	GI_SETUP_DATA_ANIMATION_DETECTION_VALUE_EX,

	GI_SETUP_DATA_ANIMATION_DETECTION_STATIC,

	GI_SETUP_DATA_ANIMATION_INTERPOLATION_COMBO_EX,

	GI_SETUP_DATA_ANIMATION_INTERPOLATION_VALUE_EX,

	GI_SETUP_DATA_ANIMATION_INTERPOLATION_STATIC,

	GI_SETUP_DATA_ANIMATION_QMC_ENABLE_EX,

	GI_SETUP_DATA_ANIMATION_QMC_VALUE_EX,



	// --- Presets

	GI_SETUP_DATA_PRESETS				= 1180,



	// --- Depth and Methods

	GI_SETUP_DATA_DIFFUSE_DEPTH			= 1200,

	GI_SETUP_DATA_DIFFUSE_STATIC,

	GI_SETUP_DATA_PRIMARY_METHOD,

	GI_SETUP_DATA_PRIMARY_INTENSITY,

	GI_SETUP_DATA_PRIMARY_STATIC,

	GI_SETUP_DATA_SECONDARY_METHOD,

	GI_SETUP_DATA_SECONDARY_INTENSITY,

	GI_SETUP_DATA_SECONDARY_STATIC,



	// --- Gamma & Saturation

	GI_SETUP_DATA_GAMMA_METHOD_EX			= 1300,

	GI_SETUP_DATA_GAMMA_VALUE,

	GI_SETUP_DATA_GAMMA_STATIC,

	// ---

	GI_SETUP_DATA_PRIMARY_SATURATION		= 1310,

	GI_SETUP_DATA_SECONDARY_SATURATION,



	// --- Extra

	GI_SETUP_DATA_EXTRA_DEBUG_LEVEL			= 1400,

	GI_SETUP_DATA_EXTRA_DIFFUSE_ONLY,

	GI_SETUP_DATA_EXTRA_HIDE_PREPASS,

	GI_SETUP_DATA_EXTRA_REFLECTIVECAUSTICS,

	GI_SETUP_DATA_EXTRA_REFRACTIVECAUSTICS,

	GI_SETUP_DATA_EXTRA_NON_DIFFUSE_CUTOFF,

	GI_SETUP_DATA_EXTRA_SHOW_SAMPLES,



	// --- QMC

	GI_SETUP_DATA_QMC_COUNT				= 2000,

	GI_SETUP_DATA_QMC_COUNT_METHOD			= 2010,

	GI_SETUP_DATA_QMC_COUNT_THRESHOLD		= 2020,

	GI_SETUP_DATA_QMC_ENABLED			= 2030,



	// ---

	//GI_SETUP_DATA_QMC_CACHE_ENABLED		= 2100,

	//GI_SETUP_DATA_QMC_CACHE_SIZE,

	// ---

	GI_SETUP_DATA_QMC_OVERSAMPLING_METHOD_EX	= 2200,

	GI_SETUP_DATA_QMC_OVERSAMPLING_RATIO_EX,

	// ---

	GI_SETUP_DATA_QMC_AREA_ENABLED			= 2300,

	GI_SETUP_DATA_QMC_AREA_FORCE			= 2310,

	GI_SETUP_DATA_QMC_AREA_CUSTOM			= 2320,

	GI_SETUP_DATA_QMC_AREA_COUNT			= 2330,

	// ---

	GI_SETUP_DATA_QMC_SKY_ENABLED			= 2400,

	GI_SETUP_DATA_QMC_SKY_FORCE			= 2410,

	GI_SETUP_DATA_QMC_SKY_CUSTOM			= 2420,

	GI_SETUP_DATA_QMC_SKY_COUNT			= 2430,

	// ---

	//GI_SETUP_DATA_QMC_AO_ENABLED			= 2500,

	//GI_SETUP_DATA_QMC_AO_GRADIENT 		= 2510,

	//GI_SETUP_DATA_QMC_AO_DISTANCE_MIN		= 2520,

	//GI_SETUP_DATA_QMC_AO_DISTANCE_MAX 		= 2530,

	//GI_SETUP_DATA_QMC_AO_CONTRAST 		= 2540,

	//GI_SETUP_DATA_QMC_AO_SELF			= 2550,



	// --- Radiosity Maps

	GI_SETUP_DATA_RADIANCE_ENABLE_EX		= 2600,

	GI_SETUP_DATA_RADIANCE_MODE			= 2610,

	GI_SETUP_DATA_RADIANCE_SCALE			= 2620,

	GI_SETUP_DATA_RADIANCE_SAMPLES			= 2630,

	// ---

	GI_SETUP_DATA_RADIANCE_AREA_ENABLE		= 2650,

	GI_SETUP_DATA_RADIANCE_AREA_SAMPLES		= 2651,

	// ---

	GI_SETUP_DATA_RADIANCE_SKY_ENABLE		= 2660,

	GI_SETUP_DATA_RADIANCE_SKY_SAMPLES		= 2661,



	// --- Light Mapping

	GI_SETUP_DATA_LIGHT_MAPPING_ENABLE_EX		= 2700,

	GI_SETUP_DATA_LIGHT_MAPPING_MODE		= 2710,

	GI_SETUP_DATA_LIGHT_MAPPING_PATH_COUNT		= 2720,

	GI_SETUP_DATA_LIGHT_MAPPING_PATH_SCALE_SCREEN	= 2721,

	GI_SETUP_DATA_LIGHT_MAPPING_PATH_DEPTH		= 2722,

	GI_SETUP_DATA_LIGHT_MAPPING_PATH_DIRECT		= 2723,

	GI_SETUP_DATA_LIGHT_MAPPING_PATH_SHOW_PATHS 	= 2724,

	GI_SETUP_DATA_LIGHT_MAPPING_PATH_CAMERA		= 2775,

	GI_SETUP_DATA_LIGHT_MAPPING_PATH_SCALE_MODE	= 2726,

	GI_SETUP_DATA_LIGHT_MAPPING_PATH_SCALE_WORLD	= 2727,

	// ---

	GI_SETUP_DATA_LIGHT_MAPPING_PREFILTER		= 2730,

	GI_SETUP_DATA_LIGHT_MAPPING_PREFILTER_COUNT	= 2731,

	// ---

	GI_SETUP_DATA_LIGHT_MAPPING_FILTER		= 2740,

	GI_SETUP_DATA_LIGHT_MAPPING_FILTER_COUNT	= 2741,

	GI_SETUP_DATA_LIGHT_MAPPING_FILTER_SCALE	= 2742,

	// ---

	GI_SETUP_DATA_LIGHT_MAPPING_RADIANCE		= 2750,

	GI_SETUP_DATA_LIGHT_MAPPING_RADIANCE_SCALE	= 2751,

	GI_SETUP_DATA_LIGHT_MAPPING_RADIANCE_SAMPLES	= 2752,



	// --- Irradiance Cache

	GI_SETUP_DATA_IR_COUNT_METHOD			= 3000,

	GI_SETUP_DATA_IR_COUNT_THRESHOLD,

	GI_SETUP_DATA_IR_COUNT_USER,



	// ---

	GI_SETUP_DATA_IR_CACHE_SECONDARY		= 3010,



	// ---

	GI_SETUP_DATA_IR_DENSITY_QUALITY		= 3200,

	GI_SETUP_DATA_IR_DENSITY_RADIUS_MAX		= 3220,

	GI_SETUP_DATA_IR_DENSITY_RADIUS_MIN,

	GI_SETUP_DATA_IR_DENSITY_CONTROL,

	GI_SETUP_DATA_IR_DENSITY_RATE_MIN		= 3204,

	GI_SETUP_DATA_IR_DENSITY_RATE_MAX,

	GI_SETUP_DATA_IR_DENSITY_PROXIMITY,



	// ---

	GI_SETUP_DATA_IR_COLOR_QUALITY			= 3300,

	GI_SETUP_DATA_IR_COLOR_PASSES,

	GI_SETUP_DATA_IR_COLOR_THRESHOLD,

	GI_SETUP_DATA_IR_COLOR_COOEF,

	GI_SETUP_DATA_IR_COLOR_CUTOFF,



	// ---

	GI_SETUP_DATA_IR_INTERPOLATION_METHOD		= 3400,

	GI_SETUP_DATA_IR_INTERPOLATION_SMOOTHING,

	GI_SETUP_DATA_IR_INTERPOLATION_MAX_SAMPLES,

	GI_SETUP_DATA_IR_INTERPOLATION_MAX_RADIUS_SCALE,

	GI_SETUP_DATA_IR_INTERPOLATION_DT_SHOW_EDGES_EX,



	// ---

	GI_SETUP_DATA_IR_OVERSAMPLING_METHOD_EX 	= 3500,

	GI_SETUP_DATA_IR_OVERSAMPLING_RATIO_EX,

	GI_SETUP_DATA_IR_OVERSAMPLING_ONLY_EX,



	// ---

	GI_SETUP_DATA_IR_DISTANCE_MAP_ENABLED		= 3600,

	GI_SETUP_DATA_IR_DISTANCE_MAP_STATIC,



	// ---

	GI_SETUP_DATA_IR_VISIBILITY_CHECK_ENABLED	= 3610,

	GI_SETUP_DATA_IR_VISIBILITY_CHECK_STATIC,



	// ---

	GI_SETUP_DATA_IR_DETAILS_ENABLE			= 3700,

	GI_SETUP_DATA_IR_DETAILS_RADIUS,

	GI_SETUP_DATA_IR_DETAILS_RATIO,

	GI_SETUP_DATA_IR_DETAILS_ADAPTIVE,

	GI_SETUP_DATA_IR_DETAILS_MODE,

	GI_SETUP_DATA_IR_DETAILS_ESTIMATE,

	GI_SETUP_DATA_IR_DETAILS_STATIC_1,

	GI_SETUP_DATA_IR_DETAILS_STATIC_2,

	GI_SETUP_DATA_IR_DETAILS_STATIC_3,

	GI_SETUP_DATA_IR_DETAILS_STATIC_4,

	GI_SETUP_DATA_IR_DETAILS_STATIC_5,

	GI_SETUP_DATA_IR_DETAILS_DIVIDER_1,

	GI_SETUP_DATA_IR_DETAILS_DIVIDER_2,



	// --- Irradiance Cache Files

	GI_SETUP_DATA_CACHE_FLUSH			= 3800,

	GI_SETUP_DATA_CACHE_FLUSH_QANIMATION,

	GI_SETUP_DATA_CACHE_LOCK,

	GI_SETUP_DATA_CACHE_AUTOLOAD,

	GI_SETUP_DATA_CACHE_AUTOSAVE,

	GI_SETUP_DATA_CACHE_SIZE_DIVIDER,

	GI_SETUP_DATA_CACHE_SIZE_RECORDS,

	GI_SETUP_DATA_CACHE_SIZE_MEMORY,

	GI_SETUP_DATA_CACHE_CUSTOM_DIVIDER,

	GI_SETUP_DATA_CACHE_CUSTOM_PATH_ENABLED,

	GI_SETUP_DATA_CACHE_CUSTOM_PATH,

	GI_SETUP_DATA_CACHE_STATIC_1,

	GI_SETUP_DATA_CACHE_STATIC_2,

	GI_SETUP_DATA_CACHE_STATIC_3,

	GI_SETUP_DATA_CACHE_STATIC_4,

	GI_SETUP_DATA_CACHE_STATIC_5,

	GI_SETUP_DATA_CACHE_PREPASS,

	GI_SETUP_DATA_CACHE_ANIMATION,



	// --- Radiance Cache Files

	GI_SETUP_DATA_RADIANCE_FLUSH			= 3900,

	GI_SETUP_DATA_RADIANCE_MEMORY,

	GI_SETUP_DATA_RADIANCE_AUTOLOAD,

	GI_SETUP_DATA_RADIANCE_AUTOSAVE,

	GI_SETUP_DATA_RADIANCE_ANIMATION,



	// --- Light Mapping Files (skip 4000 as it was used by Sky)

	GI_SETUP_DATA_LIGHT_MAPPING_FLUSH		= 4100,

	GI_SETUP_DATA_LIGHT_MAPPING_MEMORY,

	GI_SETUP_DATA_LIGHT_MAPPING_AUTOLOAD,

	GI_SETUP_DATA_LIGHT_MAPPING_AUTOSAVE,

	GI_SETUP_DATA_LIGHT_MAPPING_ANIMATION,



	// --- Sky Samples

	GI_SETUP_DATA_SKY_SAMPLES_EX			= 4000,



	// --- Irradiance Cache 2.0 (Universal)

	GI_SETUP_DATA_IC2_QUALITY			= 5300,

	GI_SETUP_DATA_IC2_RATE_MIN,

	GI_SETUP_DATA_IC2_RATE_MAX,

	GI_SETUP_DATA_IC2_DENSITY,

	GI_SETUP_DATA_IC2_DETAILS,

	GI_SETUP_DATA_IC2_SMOOTHING,

	GI_SETUP_DATA_IC2_COLOR,

	GI_SETUP_DATA_IC2_CACHE_EX,

	GI_SETUP_DATA_IC2_SCALE,



	// --- Debug (use older ids)

	GI_SETUP_DATA_IC2_GRADIENT			= 5250,

	GI_SETUP_DATA_IC2_A,

	GI_SETUP_DATA_IC2_B,

	GI_SETUP_DATA_IC2_FLAG_A,

	GI_SETUP_DATA_IC2_FLAG_B,

	GI_SETUP_DATA_IC2_MODE,

	GI_SETUP_DATA_IC2_OVERTURE,

	GI_SETUP_DATA_IC2_DETAIL_REDUCTION,

	GI_SETUP_DATA_IC2_MAX_LIMIT,

	// ---

	GI_SETUP_DATA_IC2_MODE_NORMAL			= 0,

	GI_SETUP_DATA_IC2_MODE_WEIGHTED,

	GI_SETUP_DATA_IC2_MODE_SIMPLE,

	GI_SETUP_DATA_IC2_MODE_SECONDARY,



	// --- Combo Values

	GI_SETUP_MODE_BEGGINER				= 6000,

	GI_SETUP_MODE_INTERMEDIATE,

	GI_SETUP_MODE_ADVANCED,



	// ---

	GI_SETUP_MASTER_MODE_IC_IC			= 6010,

	GI_SETUP_MASTER_MODE_IC_IC_CAMERA,

	GI_SETUP_MASTER_MODE_IC_QMC_FULL,

	GI_SETUP_MASTER_MODE_IC_QMC_FULL_NET,

	GI_SETUP_MASTER_MODE_IC_QMC,

	GI_SETUP_MASTER_MODE_IC_QMC_CAMERA,

	GI_SETUP_MASTER_MODE_QMC,

	GI_SETUP_MASTER_MODE_SKY,

	GI_SETUP_MASTER_MODE_IC2,



	// ---

	GI_SETUP_ANIMATION_DETECTION_LOW		= 6020,

	GI_SETUP_ANIMATION_DETECTION_NORMAL,

	GI_SETUP_ANIMATION_DETECTION_HIGH,

	GI_SETUP_ANIMATION_DETECTION_CUSTOM,



	// ---

	GI_SETUP_ANIMATION_INTERPOLATION_LOW		= 6030,

	GI_SETUP_ANIMATION_INTERPOLATION_NORMAL,

	GI_SETUP_ANIMATION_INTERPOLATION_HIGH,

	GI_SETUP_ANIMATION_INTERPOLATION_CUSTOM,



	// ---

	GI_SETUP_METHOD_QMC				= 6040,

	GI_SETUP_METHOD_IRRADIANCE_CACHE,

	GI_SETUP_METHOD_SKY_SAMPLER,

	GI_SETUP_METHOD_IC2,

	GI_SETUP_METHOD_CACHE,

	GI_SETUP_METHOD_RADIANCE,

	GI_SETUP_METHOD_LIGHT_MAPPING,

	GI_SETUP_METHOD_NONE,



	// ---

	GI_SETUP_GAMMA_NONE				= 6050,

	GI_SETUP_GAMMA_FINAL,

	GI_SETUP_GAMMA_RECORD,



	// ---

	GI_SETUP_COUNT_USER				= 6060,

	GI_SETUP_COUNT_CUSTOM,

	GI_SETUP_COUNT_LOW,

	GI_SETUP_COUNT_MEDIUM,

	GI_SETUP_COUNT_HIGH,



	// ---

	GI_SETUP_QUALITY_CUSTOM				= 6070,

	GI_SETUP_QUALITY_LOW,

	GI_SETUP_QUALITY_MEDIUM,

	GI_SETUP_QUALITY_HIGH,

	GI_SETUP_QUALITY_HIGH_DETAILS,

	GI_SETUP_QUALITY_DLOW,

	GI_SETUP_QUALITY_DMEDIUM,

	GI_SETUP_QUALITY_DHIGH,

	GI_SETUP_QUALITY_PREVIEW,



	// ---

	GI_SETUP_COLOR_CUSTOM				= 6080,

	GI_SETUP_COLOR_NONE,

	GI_SETUP_COLOR_LOW,

	GI_SETUP_COLOR_MEDIUM,

	GI_SETUP_COLOR_HIGH,

	GI_SETUP_COLOR_VERY_HIGH,



	// ---

	GI_SETUP_DETAILS_COMBINE			= 6090,

	GI_SETUP_DETAILS_DETAILS,

	GI_SETUP_DETAILS_GLOBAL,



	// ---

	GI_SETUP_SMOOTHING_CUSTOM			= 6100,

	GI_SETUP_SMOOTHING_MINIMAL,

	GI_SETUP_SMOOTHING_WEAK,

	GI_SETUP_SMOOTHING_MEDIUM,

	GI_SETUP_SMOOTHING_HEAVY,

	GI_SETUP_SMOOTHING_VERY_HEAVY,



	// ---

	GI_SETUP_XSAMPLING_CUSTOM			= 6110,

	GI_SETUP_XSAMPLING_NONE,

	GI_SETUP_XSAMPLING_MINIMAL,

	GI_SETUP_XSAMPLING_WEAK,

	GI_SETUP_XSAMPLING_MEDIUM,

	GI_SETUP_XSAMPLING_HEAVY,

	GI_SETUP_XSAMPLING_VERY_HEAVY,



	// ---

	GI_SETUP_INTERPOLATION_LEAST_SQUARES		= 6120,

	GI_SETUP_INTERPOLATION_D_TRIANGULATION,

	GI_SETUP_INTERPOLATION_NONE,

	GI_SETUP_INTERPOLATION_WEIGHTED,



	// ---

	GI_SETUP_DEBUG_NONE				= 6130,

	GI_SETUP_DEBUG_MINIMAL,

	GI_SETUP_DEBUG_COMPLETE,



	// ---

	GI_SETUP_DATA_ENHANCED    			= 6140,



	// ---

	GI_SETUP_RADIANCE_MODE_NORMAL			= 6150,

	GI_SETUP_RADIANCE_MODE_POINTS,

	GI_SETUP_RADIANCE_MODE_SHADED,

	GI_SETUP_RADIANCE_MODE_SHADED_FRONT,

	GI_SETUP_RADIANCE_MODE_SHADED_BACK,



	// ---

	GI_SETUP_LIGHT_MAPPING_MODE_NORMAL		= 6160,

	GI_SETUP_LIGHT_MAPPING_MODE_VISUALIZE,



	// ---

	GI_SETUP_LIGHT_MAPPING_FILTER_NONE		= 6170,

	GI_SETUP_LIGHT_MAPPING_FILTER_NEAREST,

	GI_SETUP_LIGHT_MAPPING_FILTER_FIXED,



	// ---

	GI_SETUP_LIGHT_MAPPING_SCALE_SCREEN		= 6180,

	GI_SETUP_LIGHT_MAPPING_SCALE_WORLD,



	// --- Presets (whole 6200 is reserved)

	GI_SETUP_PRESET_CUSTOM				= 6200,

	GI_SETUP_PRESET_DEFAULT				= 6201,

	// ---

	GI_SETUP_PRESET_INTERIOR_PREVIEW		= 6210,

	GI_SETUP_PRESET_INTERIOR_PREVIEW_DIFFUSE	= 6211,

	GI_SETUP_PRESET_INTERIOR_PREVIEW_AREA		= 6212,

	GI_SETUP_PRESET_INTERIOR_HIGH			= 6213,

	GI_SETUP_PRESET_INTERIOR_HIGH_DIFFUSE		= 6214,

	GI_SETUP_PRESET_INTERIOR_HIGH_AREA		= 6215,

	// ---

	GI_SETUP_PRESET_EXTERIOR_PREVIEW		= 6220,

	GI_SETUP_PRESET_EXTERIOR_SKY			= 6221,

	GI_SETUP_PRESET_EXTERIOR_HDR			= 6222,

	// ---

	GI_SETUP_PRESET_OBJECT_PREVIEW			= 6230,

	GI_SETUP_PRESET_OBJECT_HIGH			= 6231,

	// ---

	GI_SETUP_PRESET_PROGRESSIVE			= 6240,

	GI_SETUP_PRESET_PROGRESSIVE_PREPASS		= 6241,





	GI_SETUP_DATA_DUMMY

};



#endif // VPGISETUP_H__

